<?php
    $investorContent = getContent('top_investor.content', true);
    $topInvestor = \App\Models\Invest::with('user')
        ->selectRaw('SUM(amount) as totalAmount, user_id')
        ->orderBy('totalAmount', 'desc')
        ->groupBy('user_id')
        ->limit(12)
        ->get();
?>

<section class="top-investors-section py-60 bg-img"
    style="background-image: url(<?php echo e(asset($activeTemplateTrue . 'images/shapes/investor-bg.png')); ?>);">
    <div class="container">
        <div class="row mb-5">
            <div class="col-lg-12">
                <div class="section-heading style-two">
                    <h2 class="section-heading__title"> <?php echo e(__(@$investorContent->data_values->heading)); ?></h2>
                    <p class="section-heading__desc"> <?php echo e(__(@$investorContent->data_values->sub_heading)); ?></p>
                </div>
            </div>
        </div>
        <div class="row gy-4 justify-content-center">
            <?php $__currentLoopData = $topInvestor; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xl-3 col-md-6">
                    <div class="investors-item">
                        <div class="investors-item__content">
                            <span class="investors-item__username"> <?php echo e($invest->user->username); ?> </span>
                            <h3 class="investors-item__position"><?php echo e(ordinal($loop->iteration)); ?></h3>
                            <h5 class="investors-item__name"> <?php echo e($invest->user->fullname); ?> </h5>
                            <h5 class="investors-item__amount mb-0 text--base"><?php echo app('translator')->get('Investment'); ?>:
                                <?php echo e($general->cur_sym); ?><?php echo e(showAmount($invest->totalAmount)); ?> </h5>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php /**PATH D:\xampp\htdocs\updates\hyiplab\3.2\Files\core\resources\views/templates/red_hyip/sections/top_investor.blade.php ENDPATH**/ ?>