  <?php
      $planContent = getContent('plan.content', true);

      $plans = App\Models\Plan::where('status', 1)
          ->where('featured', 1)
          ->get();
      $gatewayCurrency = null;
      if (auth()->check()) {
          $gatewayCurrency = App\Models\GatewayCurrency::whereHas('method', function ($gate) {
              $gate->where('status', 1);
          })
              ->with('method')
              ->orderby('method_code')
              ->get();
      }
  ?>
  <section class="plan-section">
      <div class="plan-section__inner py-120">
          <div class="container">
              <div class="row">
                  <div class="col-lg-12">
                      <div class="section-heading">
                          <h2 class="section-heading__title"><?php echo e(__(@$planContent->data_values->heading)); ?></h2>
                          <p class="section-heading__desc"><?php echo e(__(@$planContent->data_values->sub_heading)); ?></p>
                      </div>
                  </div>
              </div>
              <div class="row gy-4 justify-content-center">
                  <?php echo $__env->make($activeTemplate . 'partials.plan', ['plans' => $plans], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
              </div>
          </div>
      </div>
  </section>
<?php /**PATH D:\xampp\htdocs\updates\hyiplab\3.2\Files\core\resources\views/templates/red_hyip/sections/plan.blade.php ENDPATH**/ ?>