<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th scope="col"><?php echo app('translator')->get('Name'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Invest Limit'); ?></th>
                                    <th><?php echo app('translator')->get('Interest'); ?></th>
                                    <th><?php echo app('translator')->get('Time'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Featured'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Status'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e(__($plan->name)); ?></td>
                                <td>
                                    <?php if($plan->fixed_amount == 0): ?>
                                        <span><?php echo e($general->cur_sym); ?><?php echo e(showAmount($plan->minimum)); ?>

                                            - <?php echo e($general->cur_sym); ?><?php echo e(showAmount($plan->maximum)); ?></span>
                                    <?php else: ?>
                                        <span><?php echo e($general->cur_sym); ?><?php echo e(showAmount($plan->fixed_amount)); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php echo e(showAmount($plan->interest)); ?> <?php if($plan->interest_type == 1): ?> % <?php else: ?> <?php echo e($general->cur_text); ?> <?php endif; ?>
                                </td>
                                <td><?php echo e($plan->time); ?> <?php echo app('translator')->get('Hours'); ?></td>
                                <td>
                                    <?php if($plan->featured == 1): ?>
                                        <span class="badge badge--success"><?php echo app('translator')->get('Yes'); ?></span>
                                    <?php else: ?>
                                        <span class="badge badge--warning"><?php echo app('translator')->get('No'); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($plan->status == 1): ?>
                                        <span class="badge badge--success"><?php echo app('translator')->get('Active'); ?></span>
                                    <?php else: ?>
                                        <span class="badge badge--warning"><?php echo app('translator')->get('Inactive'); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <button class="btn btn-sm btn-outline--primary modalShow me-2" data-type="edit" data-bs-toggle="modal" data-bs-target="#editModal" data-resource="<?php echo e($plan); ?>" data-action="<?php echo e(route('admin.plan.update',$plan->id)); ?>"><i class="las la-pen"></i><?php echo app('translator')->get('Edit'); ?></button>
                                    <?php if($plan->status): ?>
                                        <button class="btn btn-sm btn-outline--danger confirmationBtn" data-question="<?php echo app('translator')->get('Are you sure to disable this plan?'); ?>" data-action="<?php echo e(route('admin.plan.status', $plan->id)); ?>"><i class="las la-eye-slash"></i><?php echo app('translator')->get('Disable'); ?></button>
                                    <?php else: ?>
                                        <button class="btn btn-sm btn-outline--success confirmationBtn" data-question="<?php echo app('translator')->get('Are you sure to enable this plan?'); ?>" data-action="<?php echo e(route('admin.plan.status', $plan->id)); ?>"><i class="las la-eye"></i><?php echo app('translator')->get('Enable'); ?></button>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                </tr>
                            <?php endif; ?>
                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
            </div><!-- card end -->
        </div>
    </div>

    <div class="modal fade" id="addModal">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                <h5 class="modal-title"><?php echo app('translator')->get('Add New Plan'); ?></h5>
                <button type="button" class="close" data-bs-dismiss="modal">
                    <i class="las la-times"></i>
                </button>
                </div>
                <form action="<?php echo e(route('admin.plan.store')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Name'); ?></label>
                                    <input type="text" class="form-control" name="name" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Invest type'); ?></label>
                                    <select name="invest_type" class="form-control" required>
                                        <option value="1"><?php echo app('translator')->get('Range'); ?></option>
                                        <option value="2"><?php echo app('translator')->get('Fixed'); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row amount-fields"></div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Interest type'); ?></label>
                                    <select name="interest_type" class="form-control" required>
                                        <option value="1"><?php echo app('translator')->get('Percent'); ?></option>
                                        <option value="2"><?php echo app('translator')->get('Fixed'); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Interest'); ?></label>
                                    <div class="input-group">
                                        <input type="number" step="any" class="form-control" name="interest" required>
                                        <span class="input-group-text interest-type"></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Time'); ?></label>
                                    <select name="time" class="form-control" required>
                                        <option value=""><?php echo app('translator')->get('Select One'); ?></option>
                                        <?php $__currentLoopData = $times; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $time): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($time->time); ?>"><?php echo e(__($time->name)); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Return type'); ?></label>
                                    <select name="return_type" class="form-control" required>
                                        <option value="1"><?php echo app('translator')->get('Lifetime'); ?></option>
                                        <option value="0"><?php echo app('translator')->get('Repeat'); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="repeat-time row"></div>
                        <div class="form-group">
                            <label for=""><?php echo app('translator')->get('Featured'); ?></label>
                            <input type="checkbox" data-width="100%" data-onstyle="-success" data-offstyle="-danger"
                            data-bs-toggle="toggle" data-on="<?php echo app('translator')->get('Yes'); ?>" data-off="<?php echo app('translator')->get('No'); ?>" name="featured">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="editModal">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Edit Plan'); ?></h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Name'); ?></label>
                                    <input type="text" class="form-control" name="name" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Invest type'); ?></label>
                                    <select name="invest_type" class="form-control" required>
                                        <option value="1"><?php echo app('translator')->get('Range'); ?></option>
                                        <option value="2"><?php echo app('translator')->get('Fixed'); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row amount-fields"></div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Interest type'); ?></label>
                                    <select name="interest_type" class="form-control" required>
                                        <option value="1"><?php echo app('translator')->get('Percent'); ?></option>
                                        <option value="2"><?php echo app('translator')->get('Fixed'); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Interest'); ?></label>
                                    <div class="input-group">
                                        <input type="number" step="any" class="form-control" name="interest" required>
                                        <span class="input-group-text interest-type"></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Time'); ?></label>
                                    <select name="time" class="form-control" required>
                                        <?php $__currentLoopData = $times; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $time): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($time->time); ?>"><?php echo e(__($time->name)); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Return type'); ?></label>
                                    <select name="return_type" class="form-control" required>
                                        <option value="1"><?php echo app('translator')->get('Lifetime'); ?></option>
                                        <option value="0"><?php echo app('translator')->get('Repeat'); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="repeat-time row"></div>
                        <div class="form-group">
                            <label for=""><?php echo app('translator')->get('Featured'); ?></label>
                            <input type="checkbox" data-width="100%" data-onstyle="-success" data-offstyle="-danger"
                            data-bs-toggle="toggle" data-on="<?php echo app('translator')->get('Yes'); ?>" data-off="<?php echo app('translator')->get('No'); ?>" name="featured">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <?php if (isset($component)) { $__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\ConfirmationModal::class, [] + (isset($attributes) ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $constructor = (new ReflectionClass(App\View\Components\ConfirmationModal::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b)): ?>
<?php $component = $__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b; ?>
<?php unset($__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('breadcrumb-plugins'); ?>
    <button class="btn btn-outline--primary btn-sm modalShow" data-type="add" data-bs-toggle="modal" data-bs-target="#addModal"><i class="las la-plus"></i> <?php echo app('translator')->get('Add New'); ?></button>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('script'); ?>
    <script>
        (function($){
            "use strict"

            $('.modalShow').on('click',function(){

                //get modal element
                if($(this).data('type') == 'add'){
                    var modal = $('#addModal');
                }else{
                    var modal = $('#editModal');
                }
                var plan = new HyipPlan(modal, $(this));

                modal.find('[name=invest_type]').change(function() {
                    plan.getInvestType($(this).val());
                }).change()


                modal.find('[name=interest_type]').change(function() {
                    plan.getInterestType($(this).val());
                }).change()

                plan.setupEditModal();

                modal.find('[name=return_type]').change(function() {
                    plan.getReturnType($(this).val());
                }).change()


            });


            class HyipPlan{
                constructor(modal,btn){
                    this.modal = modal;
                    this.btn = btn;
                    this.resource = btn.data('resource');
                    this.action = btn.data('action');
                    this.fixedAmount = '';
                    this.minimumAmount = '';
                    this.maximumAmount = '';

                    //this block for edit modal
                    if(this.resource){
                        //set amount
                        if(this.resource.fixed_amount <= 0){
                            this.modal.find('[name=invest_type]').val(1);
                            this.minimumAmount = parseFloat(this.resource.minimum).toFixed(2);
                            this.maximumAmount = parseFloat(this.resource.maximum).toFixed(2);
                        }else{
                            this.modal.find('[name=invest_type]').val(2);
                            this.fixedAmount = parseFloat(this.resource.fixed_amount).toFixed(2);
                        }

                        //set interest type
                        if(this.resource.interest_type == 1){
                            this.modal.find('[name=interest_type]').val(1);
                        }else{
                            this.modal.find('[name=interest_type]').val(2);
                        }

                        //set repeat type
                        if(this.resource.lifetime == 1){
                            this.modal.find('[name=return_type]').val(1);
                        }else{
                            this.modal.find('[name=return_type]').val(2);
                        }
                        if(this.resource.featured){
                            this.modal.find('[name=featured]').bootstrapToggle('on');
                        }else{
                            this.modal.find('[name=featured]').bootstrapToggle('off');
                        }
                    }
                }

                getInvestType(type){
                    if(type == 1){
                        var html = `
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="required"><?php echo app('translator')->get('Minimum Invest'); ?></label>
                                    <div class="input-group">
                                        <input type="number" step="any" class="form-control" name="minimum" value="${this.minimumAmount}" required>
                                        <span class="input-group-text"><?php echo e($general->cur_text); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="required"><?php echo app('translator')->get('Maximum Invest'); ?></label>
                                    <div class="input-group">
                                        <input type="number" step="any" class="form-control" name="maximum" value="${this.maximumAmount}" required>
                                        <span class="input-group-text"><?php echo e($general->cur_text); ?></span>
                                    </div>
                                </div>
                            </div>
                            `;
                    }else{
                        var html = `
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="required"><?php echo app('translator')->get('Amount'); ?></label>
                                    <div class="input-group">
                                        <input type="number" step="any" class="form-control" name="amount" value="${this.fixedAmount}" required>
                                        <span class="input-group-text"><?php echo e($general->cur_text); ?></span>
                                    </div>
                                </div>
                            </div>
                            `;
                    }

                    this.modal.find('.amount-fields').html(html);
                }

                getInterestType(type){
                    if(type == 1){
                        this.modal.find('.interest-type').text('%');
                    }else{
                        this.modal.find('.interest-type').text('<?php echo e($general->cur_text); ?>');
                    }
                }

                getReturnType(type){
                    var html = ``;
                    var resource = this.resource;
                    if(type == 0){
                        var html = `
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="required"><?php echo app('translator')->get('Repeat Times'); ?></label>
                                    <div class="input-group">
                                        <input type="number" class="form-control" name="repeat_time" required>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Capital back'); ?></label>
                                    <select name="capital_back" class="form-control" required>
                                        <option value="1"><?php echo app('translator')->get('Yes'); ?></option>
                                        <option value="0"><?php echo app('translator')->get('No'); ?></option>
                                    </select>
                                </div>
                            </div>
                        `;
                    }
                    this.modal.find('.repeat-time').html(html);
                    if(resource){
                        this.modal.find('[name=repeat_time]').val(resource.repeat_time);
                        this.modal.find('[name=capital_back]').val(resource.capital_back);
                    }
                }

                setupEditModal(){
                    var modal = this.modal;
                    var resource = this.resource;
                    if(resource){
                        modal.find('[name=name]').val(resource.name);
                        modal.find('[name=minimum]').val(parseFloat(resource.minimum).toFixed(2));
                        modal.find('[name=maximum]').val(parseFloat(resource.maximum).toFixed(2));
                        modal.find('[name=amount]').val(parseFloat(resource.fixed_amount).toFixed(2));
                        modal.find('[name=interest]').val(parseFloat(resource.interest).toFixed(2));
                        modal.find('[name=time]').val(resource.time);
                        modal.find('[name=repeat_time]').val(resource.repeat_time);
                        modal.find('[name=capital_back]').val(resource.capital_back);
                        modal.find('[name=return_type]').val(resource.lifetime);
                        modal.find('form').attr('action',this.btn.data('action'));
                    }
                }
            }

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\updates\hyiplab\3.2\Files\core\resources\views/admin/plan/index.blade.php ENDPATH**/ ?>