<?php $__env->startSection('panel'); ?>
    <?php
        $policyPages = getContent('policy_pages.element', orderById: true);
        $registerContent = getContent('register.content', true);

    ?>

    <section class="account py-120">
        <div class="account__bg"></div>
        <div class="account__bg-shape"></div>
        <div class="account-inner">
            <div class="container py-60">
                <div class="row gy-4">
                    <div class="col-xl-6 col-lg-7">
                        <div class="account-form">
                            <a href="<?php echo e(route('home')); ?>" class="account-form__icon" title="<?php echo app('translator')->get('Home'); ?>"><i
                                    class="fas fa-home"></i></a>
                            <div class="account-form__content mb-4">
                                <h3 class="account-form__title mb-2"> <?php echo app('translator')->get('Register Account'); ?> </h3>
                            </div>
                            <form action="<?php echo e(route('user.register')); ?>" method="POST" class="verify-gcaptcha">
                                <?php echo csrf_field(); ?>

                                <div class="row gy-lg-4 gy-3">
                                    <?php if(session()->get('reference') != null): ?>
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label for="referenceBy" class="form--label"><?php echo app('translator')->get('Reference By'); ?> </label>
                                                <input type="text" name="referBy" id="referenceBy"
                                                    class="form-control form--control"
                                                    value="<?php echo e(session()->get('reference')); ?>" readonly>
                                            </div>
                                        </div>
                                    <?php endif; ?>

                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="username" class="form--label"><?php echo app('translator')->get('Username'); ?> </label>
                                            <input type="text" class="form--control checkUser" name="username"
                                                value="<?php echo e(old('username')); ?>" id="username" required>
                                            <small class="text-danger usernameExist"></small>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="email" class="form--label"><?php echo app('translator')->get('Email Address'); ?></label>
                                            <input type="email" class="form--control checkUser" name="email"
                                                value="<?php echo e(old('email')); ?>" id="email" required>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group  has-icon-select">
                                            <label for="country" class="form-label"><?php echo app('translator')->get('Country'); ?></label>
                                            <select name="country" class="select" required>
                                                <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option data-mobile_code="<?php echo e($country->dial_code); ?>"
                                                        value="<?php echo e($country->country); ?>" data-code="<?php echo e($key); ?>">
                                                        <?php echo e(__($country->country)); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="mobile" class="form--label"> <?php echo app('translator')->get('Mobile'); ?></label>
                                            <div class="input-group">
                                                <span class="input-group-text mobile-code bg--base">

                                                </span>
                                                <input type="hidden" name="mobile_code">
                                                <input type="hidden" name="country_code">
                                                <input type="number" name="mobile" value="<?php echo e(old('mobile')); ?>"
                                                    class="form-control form--control checkUser" id="mobile" required>
                                            </div>
                                            <small class="text-danger mobileExist"></small>
                                        </div>
                                    </div>

                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="password" class="form-label"><?php echo app('translator')->get('Password'); ?></label>
                                            <div class="input-group">
                                                <input type="password" class="form--control" name="password" id="password"
                                                    required>
                                                <div class="password-show-hide fas fa-eye toggle-password fa-eye-slash"
                                                    id="password"></div>
                                            </div>
                                            <?php if($general->secure_password): ?>
                                                <div class="input-popup">
                                                    <p class="error lower"><?php echo app('translator')->get('1 small letter minimum'); ?></p>
                                                    <p class="error capital"><?php echo app('translator')->get('1 capital letter minimum'); ?></p>
                                                    <p class="error number"><?php echo app('translator')->get('1 number minimum'); ?></p>
                                                    <p class="error special"><?php echo app('translator')->get('1 special character minimum'); ?></p>
                                                    <p class="error minimum"><?php echo app('translator')->get('6 character password'); ?></p>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>

                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <label class="form-label"><?php echo app('translator')->get('Confirm Password'); ?></label>
                                                <div class="input-group">
                                                    <input type="password" class="form--control"
                                                        name="password_confirmation" required>
                                                    <div class="password-show-hide fas fa-eye toggle-password fa-eye-slash"
                                                        id="password_confirmation"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="captcha-img">
                                            <?php if (isset($component)) { $__componentOriginalc0af13564821b3ac3d38dfa77d6cac9157db8243 = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\Captcha::class, [] + (isset($attributes) ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('captcha'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $constructor = (new ReflectionClass(App\View\Components\Captcha::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc0af13564821b3ac3d38dfa77d6cac9157db8243)): ?>
<?php $component = $__componentOriginalc0af13564821b3ac3d38dfa77d6cac9157db8243; ?>
<?php unset($__componentOriginalc0af13564821b3ac3d38dfa77d6cac9157db8243); ?>
<?php endif; ?>
                                        </div>
                                    </div>

                                    <?php if($general->agree): ?>
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <div class="form--check">
                                                    <input type="checkbox" class="form-check-input" id="agree"
                                                        <?php if(old('agree')): echo 'checked'; endif; ?> name="agree" required>
                                                    <div class="form-check-label">
                                                        <?php echo app('translator')->get('I agree with'); ?>
                                                        <label class="form-label" for="agree">
                                                            <?php $__currentLoopData = $policyPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $policy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <a href="<?php echo e(route('policy.pages', [slug($policy->data_values->title), $policy->id])); ?>"
                                                                    class="text--base"><?php echo e(__($policy->data_values->title)); ?></a>
                                                                <?php if(!$loop->last): ?>
                                                                    ,
                                                                <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <div class="col-sm-12">
                                        <button type="submit" class="btn btn--base w-100"><?php echo app('translator')->get('Register'); ?></button>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="have-account text-center">
                                            <p class="have-account__text"><?php echo app('translator')->get('Already Have An Account'); ?>?
                                                <a href="<?php echo e(route('user.login')); ?>"
                                                    class="have-account__link text--base">
                                                    <?php echo app('translator')->get('Login'); ?>
                                                </a>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="col-xl-7 col-lg-6">
                        <div class="account-thumb">
                            <img src="<?php echo e(getImage('assets/images/frontend/register/' . @$registerContent->data_values->image, '550x480')); ?>"
                                alt="Register Image">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <div class="modal custom--modal fade" id="existModalCenter" tabindex="-1" role="dialog"
        aria-labelledby="existModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content ">
                <div class="modal-header ">
                    <h5 class="modal-title " id="existModalLongTitle"><?php echo app('translator')->get('You are with us'); ?></h5>
                    <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body  ">
                    <h6 class="text-center "><?php echo app('translator')->get('You already have an account please Login '); ?></h6>
                </div>
                <div class="modal-footer ">
                    <button type="button" class="btn btn--secondary btn-sm text-black"
                        data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                    <a href="<?php echo e(route('user.login')); ?>" class="btn btn--base btn-sm"><?php echo app('translator')->get('Login'); ?></a>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php if($general->secure_password): ?>
    <?php $__env->startPush('script-lib'); ?>
        <script src="<?php echo e(asset('assets/global/js/secure_password.js')); ?>"></script>
    <?php $__env->stopPush(); ?>
<?php endif; ?>
<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        (function($) {
            <?php if($mobileCode): ?>
                $(`option[data-code=<?php echo e($mobileCode); ?>]`).attr('selected', '');
            <?php endif; ?>
            $('select[name=country]').change(function() {
                $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
                $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
                $('.mobile-code').text('+' + $('select[name=country] :selected').data('mobile_code'));
            });

            $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
            $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
            $('.mobile-code').text('+' + $('select[name=country] :selected').data('mobile_code'));
            <?php if($general->secure_password): ?>
                $('input[name=password]').on('input', function() {
                    secure_password($(this));
                });
                $('[name=password]').focus(function() {
                    $(this).closest('.form-group').addClass('hover-input-popup');
                });
                $('[name=password]').focusout(function() {
                    $(this).closest('.form-group').removeClass('hover-input-popup');
                });
            <?php endif; ?>
            $('.checkUser').on('focusout', function(e) {
                var url = '<?php echo e(route('user.checkUser')); ?>';
                var value = $(this).val();
                var token = '<?php echo e(csrf_token()); ?>';
                if ($(this).attr('name') == 'mobile') {
                    var mobile = `${$('.mobile-code').text().substr(1)}${value}`;
                    var data = {
                        mobile: mobile,
                        _token: token
                    }
                }
                if ($(this).attr('name') == 'email') {
                    var data = {
                        email: value,
                        _token: token
                    }
                }
                if ($(this).attr('name') == 'username') {
                    var data = {
                        username: value,
                        _token: token
                    }
                }
                $.post(url, data, function(response) {
                    if (response.data != false && response.type == 'email') {
                        $('#existModalCenter').modal('show');
                    } else if (response.data != false) {
                        $(`.${response.type}Exist`).text(`${response.type} already exist`);
                    } else {
                        $(`.${response.type}Exist`).text('');
                    }
                });
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\updates\hyiplab\3.2\Files\core\resources\views/templates/red_hyip/user/auth/register.blade.php ENDPATH**/ ?>