<?php
    $socialElement  = getContent('social_icon.element', orderById: true);
    $policyPages    = getContent('policy_pages.element', orderById: true);
    $pages          = App\Models\Page::where('tempname', $activeTemplate)->where('is_default', 0)->latest('id')->get();
    $contactElement = getContent('contact.element', orderById: true);
    $footerContent  = getContent('footer.content', true);
?>
<footer class="footer-section-wrapper">
    <div class="footer-section bg-img"
        style="background-image: url(<?php echo e(asset($activeTemplateTrue . 'images/shapes/footer-img.png')); ?>);">
        <div class="footer-section__shape"></div>
        <div class="footer-section__img">
            <img src="<?php echo e(getImage('assets/images/frontend/footer/' . @$footerContent->data_values->image,'300x275')); ?>" alt="<?php echo app('translator')->get('Footer image'); ?>">
        </div>
        <div class="pb-60 pt-120">
            <div class="container">
                <div class="row justify-content-center gy-5">
                    <div class="col-xl-3 col-sm-6">
                        <div class="footer-item">
                            <h5 class="footer-item__title"><?php echo app('translator')->get('About Us'); ?></h5>
                            <p class="footer-item__desc"><?php echo e(__(@$footerContent->data_values->content)); ?></p>

                            <ul class="social-list">
                                <?php $__currentLoopData = $socialElement; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="social-list__item"><a href="<?php echo e(@$social->data_values->url); ?>"
                                            class="social-list__link"><?php echo $social->data_values->icon; ?></a> </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                    <div class="col-xl-1 d-xl-block d-none"></div>
                    <div class="col-xl-2 col-sm-6">
                        <div class="footer-item">
                            <h5 class="footer-item__title"><?php echo app('translator')->get('Site Urls'); ?></h5>
                            <ul class="footer-menu">
                                <li class="footer-menu__item"><a href="<?php echo e(route('blogs')); ?>" class="footer-menu__link"><?php echo app('translator')->get('Blogs'); ?></a></li>
                                <li class="footer-menu__item"><a href="<?php echo e(route('contact')); ?>" class="footer-menu__link"><?php echo app('translator')->get('Contact Us'); ?></a></li>
                                <li class="footer-menu__item"><a href="<?php echo e(route('plan')); ?>"
                                        class="footer-menu__link"><?php echo app('translator')->get('Plans'); ?></a></li>
                                <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="footer-menu__item">
                                        <a href="<?php echo e(route('pages', [$data->slug])); ?>" class="footer-menu__link"><?php echo e(__($data->name)); ?></a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                    <div class="col-xl-2 col-sm-6">
                        <div class="footer-item">
                            <h5 class="footer-item__title"><?php echo app('translator')->get('Useful Link'); ?></h5>
                            <ul class="footer-menu">
                                <?php $__currentLoopData = $policyPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $policy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="footer-menu__item">
                                        <a href="<?php echo e(route('policy.pages', [slug($policy->data_values->title), $policy->id])); ?>"
                                            class="footer-menu__link"><?php echo e(__($policy->data_values->title)); ?></a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                    <div class="col-xl-1 d-xl-block d-none"></div>
                    <div class="col-xl-3 col-sm-6">
                        <div class="footer-item">
                            <h5 class="footer-item__title"><?php echo app('translator')->get('Contact Info'); ?></h5>
                            <ul class="footer-contact-menu">
                                <?php $__currentLoopData = $contactElement; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="footer-contact-menu__item">
                                    <div class="footer-contact-menu__item-icon">
                                        <?php echo @$contact->data_values->icon;
                                    ?>
                                    </div>
                                    <div class="footer-contact-menu__item-content">
                                        <?php echo e(@$contact->data_values->content); ?>

                                    </div>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="bottom-footer section-bg py-3">
            <div class="container">
                <div class="row gy-3">
                    <div class="col-md-12 text-center">
                        <p> <?php echo app('translator')->get('Copyright'); ?> &copy; <?php echo date('Y'); ?> <?php echo app('translator')->get('All Right Reserved.'); ?> </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>
<?php /**PATH D:\xampp\htdocs\updates\hyiplab\3.2\Files\core\resources\views/templates/red_hyip/partials/footer.blade.php ENDPATH**/ ?>