<header class="header" id="header">
    <div class="container">
        <nav class="navbar navbar-expand-lg navbar-light">
            <a class="navbar-brand logo" href="<?php echo e(route('home')); ?>">
                <img src="<?php echo e(getImage('assets/images/logoIcon/logo.png')); ?>" alt=" <?php echo app('translator')->get('Logo'); ?>">
            </a>
            <button class="navbar-toggler header-button" type="button" data-bs-toggle="collapse"
                data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false"
                aria-label="Toggle navigation">
                <span id="hiddenNav"><i class="las la-bars"></i></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <div class="header-account d-lg-none d-block">
                    <div class="d-flex flex-wrap justify-content-between align-items-center">
                        <ul class="login-registration-list d-flex flex-wrap justify-content-between align-items-center">
                            <?php if(auth()->guard()->guest()): ?>
                                <li class="login-registration-list__item"><span class="login-registration-list__icon"><i
                                            class="fas fa-user"></i></span><a href="<?php echo e(route('user.login')); ?>"
                                        class="login-registration-list__link"> <?php echo app('translator')->get('Login'); ?></a></li>
                                <li class="login-registration-list__item"><a href="<?php echo e(route('user.login')); ?>"
                                        class="login-registration-list__link"> <?php echo app('translator')->get('Register'); ?></a></li>
                            <?php else: ?>
                                <li class="login-registration-list__item"><a href="<?php echo e(route('user.home')); ?>" class="login-registration-list__link"> <?php echo app('translator')->get('Dashboard'); ?></a></li>
                            <?php endif; ?>
                        </ul>
                        <?php if($general->language_switch): ?>
                            <div class="language-box">
                                <div class="language-box__icon login-registration-list__icon">
                                    <i class="fas fa-globe"></i>
                                </div>
                                <select class="select langSel">
                                    <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($item->code); ?>"
                                            <?php if(session('lang') == $item->code): ?> selected <?php endif; ?>>
                                            <?php echo e(__($item->name)); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                <ul class="navbar-nav nav-menu ms-auto">
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(menuActive('home')); ?>"
                            href="<?php echo e(route('home')); ?>"><?php echo app('translator')->get('Home'); ?></a>
                    </li>
                    <?php
                        $pages = App\Models\Page::where('tempname', $activeTemplate)
                            ->where('is_default', 0)
                            ->get();
                    ?>
                    <?php if(@$pages): ?>
                        <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="nav-item">
                                <a class="nav-link <?php echo e(menuActive('pages', null, $data->slug)); ?>" href="<?php echo e(route('pages', [$data->slug])); ?>"> <?php echo e(__($data->name)); ?></a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>

                    <li class="nav-item">
                        <a class="nav-link <?php echo e(menuActive('plan')); ?>" href="<?php echo e(route('plan')); ?>"><?php echo app('translator')->get('Plans'); ?></a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link <?php echo e(menuActive('blogs')); ?>"
                            href="<?php echo e(route('blogs')); ?>"><?php echo app('translator')->get('Blogs'); ?></a>
                    </li>
                    <?php if(auth()->guard()->check()): ?>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(menuActive('ticket.open')); ?>"
                                href="<?php echo e(route('ticket.open')); ?>"><?php echo app('translator')->get('Support'); ?></a>
                        </li>
                    <?php else: ?>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(menuActive('contact')); ?>"
                                href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('Contact'); ?></a>
                        </li>
                    <?php endif; ?>
                </ul>

                <div class="header-account d-lg-block d-none">
                    <div class="d-flex flex-wrap justify-content-between align-items-center">
                        <ul class="login-registration-list d-flex flex-wrap justify-content-between align-items-center">
                            <?php if(auth()->guard()->guest()): ?>
                                <li class="login-registration-list__item"><span class="login-registration-list__icon"><i class="fas fa-user"></i></span>
                                    <a href="<?php echo e(route('user.login')); ?>" class="login-registration-list__link">
                                        <?php echo app('translator')->get('Login'); ?></a>
                                </li>

                                <li class="login-registration-list__item"><a href="<?php echo e(route('user.register')); ?>" class="login-registration-list__link"> <?php echo app('translator')->get('Register'); ?></a></li>
                            <?php else: ?>

                            <li class="login-registration-list__item"><span class="login-registration-list__icon"><i class="fas fa-user"></i></span>
                                <a href="<?php echo e(route('user.home')); ?>" class="login-registration-list__link">
                                    <?php echo app('translator')->get('Dashboard'); ?></a>
                            </li>

                            <li class="login-registration-list__item"><a href="<?php echo e(route('user.logout')); ?>" class="login-registration-list__link"> <?php echo app('translator')->get('logout'); ?></a></li>

                            <?php endif; ?>
                        </ul>
                        <?php if($general->language_switch): ?>
                            <div class="language-box">
                                <div class="language-box__icon login-registration-list__icon">
                                    <i class="fas fa-globe"></i>
                                </div>
                                <select class="select langSel">
                                    <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($item->code); ?>"
                                            <?php if(session('lang') == $item->code): ?> selected <?php endif; ?>>
                                            <?php echo e(__($item->name)); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </nav>
    </div>
</header>
<?php /**PATH D:\xampp\htdocs\updates\hyiplab\3.2\Files\core\resources\views/templates/red_hyip/partials/header.blade.php ENDPATH**/ ?>