


<?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php
        $timeName = \App\Models\TimeSetting::where('time', $plan->time)->first();
    ?>



    <div class="col-xl-4 col-md-6 gy-3">
        <div class="plan-item">
            <h3 class="plan-item__parcentage"><?php echo app('translator')->get('Profit'); ?>:
                <?php echo e($plan->interest_type != 1 ? $general->cur_sym : ''); ?><?php echo e(showAmount($plan->interest)); ?><?php echo e($plan->interest_type == 1 ? '%' : ''); ?>

            </h3>
            <div class="plan-item__shape"></div>
            <div class="plan-item__card">
                <div class="plan-item__card-inner">
                    <div class="plan-item__content">
                        <div class="plan-item__header">
                            <h3 class="plan-item__title"><?php echo e(__($plan->name)); ?></h3>
                        </div>
                        <div class="plan-item__body">
                            <ul class="text-list">
                                <li class="text-list__item"> <span class="icon"><i
                                            class="fas fa-check-circle"></i></span> <?php echo app('translator')->get('Every'); ?>
                                    <?php echo e(__($timeName->name)); ?> </li>
                                <li class="text-list__item"> <span class="icon"><i
                                            class="fas fa-check-circle"></i></span><?php echo app('translator')->get('For'); ?>

                                    <?php if($plan->lifetime == 0): ?>
                                        <?php echo e(__($plan->repeat_time)); ?> <?php echo e(__($timeName->name)); ?>

                                    <?php else: ?>
                                        <?php echo app('translator')->get('Lifetime'); ?>
                                    <?php endif; ?>
                                </li>
                                <li class="text-list__item"> <span class="icon"><i
                                            class="fas fa-check-circle"></i></span>
                                    <?php if($plan->lifetime == 0): ?>
                                        <?php echo app('translator')->get('Total'); ?>
                                        <?php echo e($plan->interest_type != 1 ? $general->cur_sym : ''); ?><?php echo e(__($plan->interest * $plan->repeat_time)); ?><?php echo e($plan->interest_type == 1 ? '%' : ''); ?>

                                        <?php if($plan->capital_back == 1): ?>
                                            +
                                            <span class="badge badge--base ">
                                                <?php echo app('translator')->get('Capital'); ?>
                                            </span>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <?php echo app('translator')->get('Unlimited Earning'); ?>
                                    <?php endif; ?>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="plan-item__footer">
                        <div class="plan-item__footer-inner">
                            <?php if($plan->fixed_amount == 0): ?>
                                <span class="plan-item__footer-text d-block"><?php echo app('translator')->get('Min :'); ?>
                                    <?php echo e($general->cur_sym); ?><?php echo e(showAmount($plan->minimum)); ?></span>
                                <span class="plan-item__footer-text d-block"><?php echo app('translator')->get('Max :'); ?>
                                    <?php echo e($general->cur_sym); ?><?php echo e(showAmount($plan->maximum)); ?></span>
                            <?php else: ?>
                                <span class="plan-item__footer-text d-block"><?php echo app('translator')->get('Fixed :'); ?>
                                    <?php echo e($general->cur_sym); ?><?php echo e(showAmount($plan->fixed_amount)); ?></span>
                                <div class="mb-5"></div>
                            <?php endif; ?>

                            <a href="javascript:void(0)" class="btn btn--white pill investModal" data-bs-toggle="modal"
                                data-plan=<?php echo e($plan); ?> data-bs-target="#investModal"><?php echo app('translator')->get('Invest Now'); ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


<div class="modal custom--modal fade" id="investModal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <?php if(auth()->check()): ?>
                    <strong class="modal-title " id="ModalLabel">
                        <?php echo app('translator')->get('Confirm to invest on'); ?> <span class="planName"></span>
                    </strong>
                <?php else: ?>
                    <strong class="modal-title " id="ModalLabel">
                        <?php echo app('translator')->get('At first login your account'); ?>
                    </strong>
                <?php endif; ?>
                <button class="close" class="text--base" data-bs-dismiss="modal">
                    <i class="las la-times"></i>
                </button>
            </div>
            <div class="modal-body">

                <form action="<?php echo e(route('user.invest.submit')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="plan_id">
                    <?php if(auth()->check()): ?>
                        <div class="modal-body">
                            <div class="form-group">
                                <h6 class="text-center investAmountRange"></h6>
                                <p class="text-center mt-1 interestDetails"></p>
                                <p class="text-center interestValidity"></p>

                                <label><?php echo app('translator')->get('Select Wallet'); ?></label>
                                <select class="form--control  select" name="wallet_type" required>
                                    <option value=""><?php echo app('translator')->get('Select One'); ?></option>
                                    <?php if(auth()->user()->deposit_wallet > 0): ?>
                                        <option value="deposit_wallet"><?php echo app('translator')->get('Deposit Wallet - ' . $general->cur_sym . showAmount(auth()->user()->deposit_wallet)); ?></option>
                                    <?php endif; ?>
                                    <?php if(auth()->user()->interest_wallet > 0): ?>
                                        <option value="interest_wallet"><?php echo app('translator')->get('Interest Wallet -' . $general->cur_sym . showAmount(auth()->user()->interest_wallet)); ?></option>
                                    <?php endif; ?>
                                    <?php $__currentLoopData = $gatewayCurrency; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($data->id); ?>" <?php if(old('wallet_type') == $data->method_code): echo 'selected'; endif; ?>
                                            data-gateway="<?php echo e($data); ?>"><?php echo e($data->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <code class="gateway-info rate-info d-none"><?php echo app('translator')->get('Rate'); ?>: 1 <?php echo e($general->cur_text); ?>

                                    = <span class="rate"></span> <span class="method_currency"></span></code>
                            </div>
                            <div class="form-group">
                                <label><?php echo app('translator')->get('Invest Amount'); ?></label>
                                <div class="input-group">
                                    <input type="number" step="any" class="form-control form--control" name="amount"
                                        required>
                                    <span class="input-group-text bg--base"><?php echo e($general->cur_text); ?></span>
                                </div>
                                <code class="gateway-info d-none"><?php echo app('translator')->get('Charge'); ?>: <span class="charge"></span>
                                    <?php echo e($general->cur_text); ?>. <?php echo app('translator')->get('Total amount'); ?>: <span class="total"></span>
                                    <?php echo e($general->cur_text); ?></code>
                            </div>
                        </div>
                        <?php else: ?>
                         <p><?php echo app('translator')->get('Login Required'); ?></p>
                    <?php endif; ?>
                </form>
            </div>
            <div class="modal-footer">
                <?php if(auth()->check()): ?>
                    <button type="button" class="btn btn-secondary btn-sm text-black"
                        data-bs-dismiss="modal"><?php echo app('translator')->get('No'); ?></button>
                    <button type="submit" class="btn btn--base btn-sm"><?php echo app('translator')->get('Yes'); ?></button>
                    <?php else: ?>
                    <a href="<?php echo e(route('user.login')); ?>"
                        class="btn btn--base btn-sm h-45 w-100 text-center"><?php echo app('translator')->get('Login Now'); ?></a>

                <?php endif; ?>
            </div>
        </div>
    </div>
</div>



<?php $__env->startPush('style'); ?>
    <style>


        .form--control:disabled,
        .form--control[readonly] {
            background-color: hsl(var(--base-two-d-200));
            opacity: 1;
            border: 1px solid hsl(var(--white)/0.15);
        }

        .custom--modal .modal-body .select {
            margin-bottom: 10px;
        }

        .custom--modal .modal-body label {
            margin-bottom: 10px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict"
            $('.investModal').click(function() {
                var symbol = '<?php echo e($general->cur_sym); ?>';
                var currency = '<?php echo e($general->cur_text); ?>';
                $('.gateway-info').addClass('d-none');
                var modal = $('#investModal');
                var plan = $(this).data('plan');
                modal.find('.planName').text(plan.name)
                modal.find('[name=plan_id]').val(plan.id);
                let fixedAmount = parseFloat(plan.fixed_amount).toFixed(2);
                let minimumAmount = parseFloat(plan.minimum).toFixed(2);
                let maximumAmount = parseFloat(plan.maximum).toFixed(2);
                let interestAmount = parseFloat(plan.interest);

                if (plan.fixed_amount > 0) {
                    modal.find('.investAmountRange').text(`Invest: ${symbol}${fixedAmount}`);
                    modal.find('[name=amount]').val(fixedAmount);
                    modal.find('[name=amount]').attr('readonly', true);
                } else {
                    modal.find('.investAmountRange').text(
                        `Invest: ${symbol}${minimumAmount} - ${symbol}${maximumAmount}`);
                    modal.find('[name=amount]').val('');
                    modal.find('[name=amount]').removeAttr('readonly');
                }

                if (plan.interest_type == '1') {
                    modal.find('.interestDetails').html(`<strong> Interest: ${interestAmount}% </strong>`);
                } else {
                    modal.find('.interestDetails').html(
                        `<strong> Interest: ${interestAmount} ${currency}  </strong>`);
                }
                if (plan.lifetime_status == '0') {
                    modal.find('.interestValidity').html(
                        `<strong>  Per ${plan.time} hours ,  ${plan.repeat_time} times</strong>`);
                } else {
                    modal.find('.interestValidity').html(
                        `<strong>  Per ${plan.time} hours,  life time </strong>`);
                }

            });

            $('[name=amount]').on('input', function() {
                $('[name=wallet_type]').trigger('change');
            })

            $('[name=wallet_type]').change(function() {
                var amount = $('[name=amount]').val();
                if ($(this).val() != 'deposit_wallet' && $(this).val() != 'interest_wallet' && amount) {
                    var resource = $('select[name=wallet_type] option:selected').data('gateway');
                    var fixed_charge = parseFloat(resource.fixed_charge);
                    var percent_charge = parseFloat(resource.percent_charge);
                    var charge = parseFloat(fixed_charge + (amount * percent_charge / 100)).toFixed(2);
                    $('.charge').text(charge);
                    $('.rate').text(parseFloat(resource.rate));
                    $('.gateway-info').removeClass('d-none');
                    if (resource.currency == '<?php echo e($general->cur_text); ?>') {
                        $('.rate-info').addClass('d-none');
                    } else {
                        $('.rate-info').removeClass('d-none');
                    }
                    $('.method_currency').text(resource.currency);
                    $('.total').text(parseFloat(charge) + parseFloat(amount));
                } else {
                    $('.gateway-info').addClass('d-none');
                }
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH D:\xampp\htdocs\updates\hyiplab\3.2\Files\core\resources\views/templates/red_hyip/partials/plan.blade.php ENDPATH**/ ?>