 <?php
     $latestDeposit = \App\Models\Deposit::with('user', 'gateway')
         ->where('status', 1)
         ->latest()
         ->limit(10)
         ->get();
     $fakeDeposit = \App\Models\Frontend::where('data_keys', 'transaction.element')
         ->whereJsonContains('data_values->trx_type', 'deposit')
         ->limit(10)
         ->get();
     $deposits = $latestDeposit->merge($fakeDeposit);
     $deposits = $deposits->sortByDesc('created_at')->take(10);

     $latestWithdraw = \App\Models\Withdrawal::with('user', 'method')
         ->where('status', 1)
         ->latest()
         ->limit(10)
         ->get();
     $fakeWithdraw = \App\Models\Frontend::where('data_keys', 'transaction.element')
         ->whereJsonContains('data_values->trx_type', 'withdraw')
         ->limit(10)
         ->get();

     $withdrawals = $latestWithdraw->merge($fakeWithdraw);
     $withdrawals = $withdrawals->sortByDesc('created_at')->take(10);
     $transactionContent = getContent('transaction.content', true);
 ?>

 <section class="transaction py-60">
     <div class="container">
         <div class="row">
             <div class="col-lg-12">
                 <div class="section-heading">
                     <h2 class="section-heading__title"><?php echo e(__($transactionContent->data_values->heading)); ?> </h2>
                     <p class="section-heading__desc"><?php echo e(__($transactionContent->data_values->sub_heading)); ?></p>
                 </div>
             </div>
         </div>
         <div class="row gy-5">
             <div class="col-lg-6">
                 <h3 class="table-heading"><?php echo app('translator')->get('Latest Deposits'); ?></h3>
                 <table class="table table--responsive--lg">
                     <thead>
                         <tr>
                             <th><?php echo app('translator')->get('Gatway'); ?></th>
                             <th><?php echo app('translator')->get('Date'); ?></th>
                             <th><?php echo app('translator')->get('Amount'); ?></th>
                         </tr>
                     </thead>
                     <tbody>
                         <?php $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                             <tr>
                                 <?php if(@$deposit->data_values): ?>
                                     <td data-label="<?php echo app('translator')->get('Gatway'); ?>">
                                         <?php echo e(__(@$deposit->data_values->gateway)); ?>

                                     </td>
                                     <td data-label="<?php echo app('translator')->get('date'); ?>">
                                         <?php echo e(showDateTime(@$deposit->data_values->created_at)); ?>

                                     </td>
                                     <td data-label="<?php echo app('translator')->get('Amount'); ?>">
                                         <?php echo e(showAmount(@$deposit->data_values->amount)); ?>

                                         <?php echo e($general->cur_text); ?>

                                     </td>
                                 <?php else: ?>
                                     <td data-label="<?php echo app('translator')->get('Gatway'); ?>">
                                         <?php echo e(__(@$deposit->gateway->name)); ?>

                                     </td>
                                     <td data-label="<?php echo app('translator')->get('date'); ?>">
                                         <?php echo e(showDateTime(@$deposit->created_at)); ?>

                                     </td>
                                     <td data-label="<?php echo app('translator')->get('Amount'); ?>">
                                         <?php echo e(showAmount(@$deposit->amount)); ?>

                                         <?php echo e($general->cur_text); ?>

                                     </td>
                                 <?php endif; ?>
                             </tr>
                         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                     </tbody>
                 </table>
             </div>
             <div class="col-lg-6">
                 <h3 class="table-heading"> <?php echo app('translator')->get('Latest Withdraws'); ?> </h3>
                 <table class="table table--responsive--lg">
                     <thead>
                         <tr>
                             <th><?php echo app('translator')->get('Gatway'); ?></th>
                             <th><?php echo app('translator')->get('Date'); ?></th>
                             <th><?php echo app('translator')->get('Amount'); ?></th>
                         </tr>
                     </thead>
                     <tbody>
                        <?php $__currentLoopData = $withdrawals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $withdrawal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>

                            <?php if($withdrawal->data_values): ?>
                                <td data-label="<?php echo app('translator')->get('Gatway'); ?>">
                                    <?php echo e(__(@$withdrawal->data_values->gateway)); ?>

                                </td>
                                <td data-label="<?php echo app('translator')->get('date'); ?>">
                                    <?php echo e(showDateTime($withdrawal->data_values->date)); ?>

                                </td>
                                <td data-label="<?php echo app('translator')->get('Amount'); ?>">
                                    <?php echo e(showAmount($withdrawal->data_values->amount)); ?>

                                    <?php echo e($general->cur_text); ?>

                                </td>
                            <?php else: ?>
                                <td data-label="<?php echo app('translator')->get('Gatway'); ?>">
                                    <?php echo e(__(@$withdrawal->gateway->name)); ?>

                                </td>
                                <td data-label="<?php echo app('translator')->get('date'); ?>">
                                    <?php echo e(showDateTime($withdrawal->created_at)); ?>

                                </td>
                                <td data-label="<?php echo app('translator')->get('Amount'); ?>">
                                    <?php echo e(showAmount($withdrawal->amount)); ?>

                                    <?php echo e($general->cur_text); ?>

                                </td>
                            <?php endif; ?>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                     </tbody>
                 </table>
             </div>
         </div>
     </div>
 </section>
<?php /**PATH D:\xampp\htdocs\updates\hyiplab\3.2\Files\core\resources\views/templates/red_hyip/sections/transaction.blade.php ENDPATH**/ ?>