<?php $__env->startSection('content'); ?>
    <?php
        $contactContent = getContent('contact.content', true);
        $contactElement = getContent('contact.element', orderById: true);
    ?>
    <section class="contact-top pt-120 pb-60">
        <div class="container">
            <div class="row gy-4 justify-content-center">
                <?php $__currentLoopData = $contactElement; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="contact-item">
                            <div class="contact-item__shape"></div>
                            <div class="contact-item__box">
                                <div class="contact-item__icon">
                                    <?php echo $contact->data_values->icon; ?>
                                </div>
                                <div class="contact-item__content">
                                    <h4 class="contact-item__title"><?php echo e(__(@$contact->data_values->title)); ?></h4>
                                    <p class="contact-item__desc">
                                        <?php echo e(__(@$contact->data_values->content)); ?>

                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>

    <section class="contact-bottom pt-60 pb-120">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    <div class="contactus-form">
                        <h3 class="contact__title text-center"> <?php echo app('translator')->get('Get In Touch With Us'); ?></h3>
                        <form autocomplete="off" method="post" action="" class="verify-gcaptcha">
                            <?php echo csrf_field(); ?>
                            <div class="row gy-md-4 gy-3">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label class="form-label"><?php echo app('translator')->get('Name'); ?></label>
                                        <input name="name" type="text" class="form--control"
                                                    value="<?php if(auth()->user()): ?> <?php echo e(auth()->user()->fullname); ?><?php else: ?><?php echo e(old('name')); ?><?php endif; ?>"
                                                    <?php if(auth()->user()): ?> readonly <?php endif; ?> required>
                                    </div>
                                </div>

                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label class="form-label"><?php echo app('translator')->get('Email'); ?></label>
                                        <input name="email" type="email" class="form--control"
                                            value="<?php if(auth()->user()): ?> <?php echo e(auth()->user()->email); ?><?php else: ?><?php echo e(old('email')); ?> <?php endif; ?>"
                                            <?php if(auth()->user()): ?> readonly <?php endif; ?> required>
                                    </div>
                                </div>

                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label class="form-label"><?php echo app('translator')->get('Subject'); ?></label>
                                        <input name="subject" type="text" class="form--control"
                                            value="<?php echo e(old('subject')); ?>" required>
                                    </div>
                                </div>

                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label class="form-label"><?php echo app('translator')->get('Message'); ?></label>
                                        <textarea name="message" wrap="off" class="form--control" required><?php echo e(old('message')); ?></textarea>
                                    </div>
                                </div>

                                <div class="col-sm-12">
                                    <?php if (isset($component)) { $__componentOriginalc0af13564821b3ac3d38dfa77d6cac9157db8243 = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\Captcha::class, [] + (isset($attributes) ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('captcha'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $constructor = (new ReflectionClass(App\View\Components\Captcha::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc0af13564821b3ac3d38dfa77d6cac9157db8243)): ?>
<?php $component = $__componentOriginalc0af13564821b3ac3d38dfa77d6cac9157db8243; ?>
<?php unset($__componentOriginalc0af13564821b3ac3d38dfa77d6cac9157db8243); ?>
<?php endif; ?>
                                </div>

                                <div class="col-sm-12">
                                    <button class=" btn btn--base w-100"> <?php echo app('translator')->get('Send Your Message'); ?> <span
                                            class="button__icon ms-1"><i class="fas fa-paper-plane"></i></span></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="contact">
        <div class="contact-map">
            <iframe src="<?php echo e(@$contactContent->data_values->map_url); ?>" allowfullscreen="" loading="lazy"
                referrerpolicy="no-referrer-when-downgrade"></iframe>
        </div>
    </section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\updates\hyiplab\3.2\Files\core\resources\views/templates/red_hyip/contact.blade.php ENDPATH**/ ?>